// math definitions

#ifndef _MATH2_H_
#define _MATH2_H_

typedef unsigned short ROT;

typedef struct {
  float x;
  float y;
  float z;
} VECTOR;

typedef struct {
  float el[3][4];
} MATRIX;

typedef struct {
  float x, y, z;
  float nx, ny, nz;
//  float u, v;
} VERTEX;

#define STYLE_ENVMAP 0

typedef struct {
  unsigned short a, b, c;
  float nx, ny, nz;

  unsigned short u1, v1;
  unsigned short u2, v2;
  unsigned short u3, v3;

  unsigned char style;
  unsigned char visible;
  unsigned short ID;

} PLANE;


extern float Cos( unsigned short angle );
extern float Sin( unsigned short angle );

extern void matrix_mul ( MATRIX *a,MATRIX *b, MATRIX *d );
extern void rotate_z_matrix (int v, MATRIX *m);
extern void rotate_x_matrix (int v, MATRIX *m);
extern void rotate_y_matrix (int v, MATRIX *m);
extern void build_rotation_matrix( ROT x, ROT y, ROT z, MATRIX *m );
extern void matrix_from_vectors ( VECTOR *direction, VECTOR *upvect, MATRIX *m );

extern void vector_mul ( MATRIX *m, VECTOR *v, VECTOR *dv );
extern void vector_crossproduct( VECTOR *dst, VECTOR *a, VECTOR *b );
extern float vector_dotproduct( VECTOR *a, VECTOR *b );
extern float vector_length( VECTOR *a );
extern void vector_normalize( VECTOR *a );
extern void vector_add( VECTOR *dest, VECTOR *src );
extern void vector_sub( VECTOR *dest, VECTOR *src );

extern void invert_matrix( MATRIX m, MATRIX *r );

VECTOR vector(float x, float y, float z);

inline long ceil(long x)
{
    x +=  0xffff;
    return (x >> 16);
}

/*
long imul16(long x, long y);        // (x * y) >> 16
pragma aux imul16 = \
    " imul  edx        "\
    " shrd  eax,edx,16 "\
    parm [eax] [edx] value [eax]


long imul14(long x, long y);        // (x * y) >> 14
pragma aux imul14 = \
    " imul  edx        "\
    " shrd  eax,edx,14 "\
    parm [eax] [edx] value [eax]


long idiv16(long x, long y);        // (x << 16) / y
pragma aux idiv16 = \
    " mov   edx,eax    "\
    " sar   edx,16     "\
    " shl   eax,16     "\
    " idiv  ebx        "\
    parm [eax] [ebx] modify exact [eax edx] value [eax]
*/

#endif
